IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_AR_Padron_IIBB_Import') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_AR_Padron_IIBB_Import
END
GO


CREATE  PROCEDURE [dbo].[CPJ_AR_Padron_IIBB_Import] @pJson VARCHAR(8000)
AS

/*Parametros */

DECLARE  @Id_Tipo_Reten VARCHAR(10)
		,@Id_Tipo_Percep VARCHAR(10)
		,@Archivo VARCHAR(1000)
		,@Provincia INT
		
/*
0	Ciudad Autónoma de Buenos Aires
1	Buenos Aires
2	Catamara
3	Córdoba
4	Corrientes
5	Entre Ríos
6	Jujuy
7	Mendoza
8	La Rioja
9	Salta
10	San Juan
11	San Luis
12	Santa Fe
13	Santiago del Estero
14	Tucumán
16	Chaco
17	Chubut
18	Formosa
19	Misiones
20	Neuquén
21	La Pampa
22	Río Negro
23	Santa Cruz
24	Tierra del Fuego
*/

SET @Id_Tipo_Reten		= ISNULL(CONVERT(VARCHAR(10)	, dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Reten')),'')
SET @Id_Tipo_Percep		= ISNULL(CONVERT(VARCHAR(10)	, dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Percep')),'')
SET @Archivo			= ISNULL(CONVERT(VARCHAR(1000)	, dbo.CF_JSON_VALUE(@pJson,'Archivo')), '')
SET @Provincia			= ISNULL(CONVERT(INT			, dbo.CF_JSON_VALUE(@pJson,'Provincia')), 0)

IF @Id_Tipo_Reten = '' AND @Id_Tipo_Percep = '' RETURN
IF @Archivo = ''								RETURN
IF @Provincia = 0								RETURN
/*************************** Fin de Parametros *****************************/

DECLARE @Mensaje			VARCHAR(100)
		,@sql NVARCHAR(4000)
		,@cant INT


BEGIN TRY
BEGIN TRAN

SET @cant = 0
 
CREATE TABLE #AR_Padron_IIBB_Temp (Linea VARCHAR(500) )
 
SET @sql = 'BULK INSERT #AR_Padron_IIBB_Temp
		FROM '''+ @Archivo + '''
		WITH ( DATAFILETYPE =''char'' ,FIELDTERMINATOR= ''|'', ROWTERMINATOR = ''0x0a'' );'

EXEC (@sql)



IF @Provincia = 0  --CABA
BEGIN
	IF ISNULL(@Id_Tipo_Reten,'') <> ''
	BEGIN
	    DELETE AR_Padron_IIBB WHERE Id_Tipo_Reten = @Id_Tipo_Reten
		INSERT INTO AR_Padron_IIBB
			SELECT CAST(SUBSTRING(Linea,28,11) AS VARCHAR(19))
				,@Id_Tipo_Reten,GETDATE()
				,0
				,CAST(SUBSTRING(Linea,46,1) +'.' + SUBSTRING(Linea,48,2) AS DECIMAL(7,2))
				FROM #AR_Padron_IIBB_Temp
	END
	
	IF ISNULL(@Id_Tipo_Percep,'') <> ''
	BEGIN
	    DELETE AR_Padron_IIBB WHERE Id_Tipo_Reten = @Id_Tipo_Percep
		INSERT INTO AR_Padron_IIBB
			SELECT CAST(SUBSTRING(Linea,28,11) AS VARCHAR(19))
				,@Id_Tipo_Percep,GETDATE()
				,0
				,CAST(SUBSTRING(Linea,51,1) +'.' + SUBSTRING(Linea,53,2) AS DECIMAL(7,2))
				FROM #AR_Padron_IIBB_Temp
	END
END




IF @Provincia = 1  --Buenos Aires
BEGIN
	IF ISNULL(@Id_Tipo_Reten,'') <> ''
	BEGIN
	    DELETE AR_Padron_IIBB WHERE Id_Tipo_Reten = @Id_Tipo_Reten
		INSERT INTO AR_Padron_IIBB
			SELECT CAST(SUBSTRING(Linea,30,11) AS VARCHAR(19))
				,@Id_Tipo_Reten,GETDATE()
				,0
				,CAST(SUBSTRING(Linea,48,1) +'.' + SUBSTRING(Linea,50,2) AS DECIMAL(7,2))
				FROM #AR_Padron_IIBB_Temp
	END

	IF ISNULL(@Id_Tipo_Percep,'') <> ''
	BEGIN
	    DELETE AR_Padron_IIBB WHERE Id_Tipo_Reten = @Id_Tipo_Percep
		INSERT INTO AR_Padron_IIBB
			SELECT CAST(SUBSTRING(Linea,30,11) AS VARCHAR(19))
				,@Id_Tipo_Percep,GETDATE()
				,0
				,CAST(SUBSTRING(Linea,48,1) +'.' + SUBSTRING(Linea,50,2) AS DECIMAL(7,2))
				FROM #AR_Padron_IIBB_Temp
	END
END



IF ISNULL(@Id_Tipo_Percep,'') <> ''
BEGIN
	DELETE FROM Clientes_Reten WHERE Id_Tipo_Reten = @Id_Tipo_Reten
	INSERT INTO Clientes_Reten
		SELECT B.Id_Cliente , @Id_Tipo_Reten,A.Porc,A.Coef 
				FROM [dbo].[AR_Padron_IIBB] A, Clientes B 
				WHERE A.Cuit = B.Cuit AND A.Id_Tipo_Reten = @Id_Tipo_Reten
   SELECT @cant = COUNT(*) FROM Clientes_Reten WHERE Id_Tipo_Reten = @Id_Tipo_Percep

END 

IF ISNULL(@Id_Tipo_Reten,'') <> ''
BEGIN
	DELETE FROM Proveedores_Reten where Id_Tipo_Reten = @Id_Tipo_Reten
	INSERT INTO Proveedores_Reten
		SELECT B.Id_Proveedor , @Id_Tipo_Reten,A.Porc,A.Coef 
				FROM [dbo].[AR_Padron_IIBB] A, Proveedores B 
				WHERE A.Cuit = B.Cuit AND A.Id_Tipo_Reten = @Id_Tipo_Reten
	SELECT @cant += COUNT(*) FROM Proveedores_Reten WHERE Id_Tipo_Reten = @Id_Tipo_Reten

END 

SET @Mensaje = CONVERT(VARCHAR(10),@cant) + ' Registros Importados'
DROP TABLE #AR_Padron_IIBB_Temp

COMMIT
SELECT	 0					AS ErrorNumber 
		,0					AS ErrorSeverity  
		,0					AS ErrorState 
		,0					AS ErrorProcedure  
		,@cant 				AS ErrorLine		
		,@Mensaje			AS ErrorMessage

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   

/*

EXEC CPJ_AR_Padron_IIBB_Import  '{
												"Id_Tipo_Reten":"",
												"Archivo":"0",
												"ModoDebug":"0",
												"Tipo":"R"
											  }'


*/